//
//  ButtonPullDownPrepare.h
//  22222222222222
//
//  Created by liangchenying on 12-4-9.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface ButtonPullDownPrepare : NSObject<UIActionSheetDelegate>
- (id)initWithTarget:(id)origin;

- (void)showSheetPicker;

- (UIPickerView *)configuredPickerView;

- (void)notifyDoneButton;
- (void)notifyCancelButton;

- (UIBarButtonItem *)createToolbarTitle :(NSString *)title;
- (UIToolbar       *)createSheetPickerToolbarTitle:(NSString *)title;

- (UIBarButtonItem *)createButton:(UIBarButtonSystemItem)type target:(id)target action:(SEL)buttonAction;

- (void)presentPickerForView:(UIView *)view;

- (void)configureAndPresentActionSheetForView:(UIView *)view;
- (void)configureAndPresentPopoverForView    :(UIView *)view;

- (IBAction)actionPickerDone  :(id)sender;
- (IBAction)actionPickerCancel:(id)sender;

- (void)dismissPicker;

@property (nonatomic, copy)   NSString            *title;
@property (nonatomic, retain) UIView              *picker_view;
@property (nonatomic, retain) UIView              *container_view;
@property (nonatomic, retain) UIActionSheet       *action_sheet;
@property (nonatomic, retain) UIPopoverController *pop_over_controller;
@property (nonatomic, retain) NSObject            *self_reference;

#pragma mark for iPhone / iPod touch
@property (nonatomic, retain) UIView               *baseView;
@property (nonatomic, retain) UIView               *blockView;

@end

